close all
IAB = readtable('../Data/IAB_Data/iab.xlsx');

figNum = 1;

figure(figNum);
plot(IAB.year,IAB.quit_temp_1,ls.lineSpec1{:});
hold on 
plot(IAB.year,IAB.quit_longterm_1,ls.lineSpec2{:});
plot(IAB.year,IAB.seasonal_demand_1,ls.lineSpec3{:});
plot(IAB.year,IAB.demand_longterm_1,ls.lineSpec4{:});
hold off

grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})

%xlabel('Year');
ylabel('Share');
legend('Replacement (Temporary)', 'Replacement (Long-term)', 'Demand Increase (Temporary)', 'Demand Increase (Long-term)','Location','east');

export_fig(figure(figNum),[ls.graphPath 'IAB_Vacancy_Share'],'-pdf','-transparent');

figNum = figNum +1;


%% Bar chart

quitTemp = mean(IAB.quit_temp_1);
quitLong = mean(IAB.quit_longterm_1);
demSeas = mean(IAB.seasonal_demand_1);
demLong = mean(IAB.demand_longterm_1);


categories = categorical({'Replacement Hiring';'New Job Creation'});
vac = [quitTemp quitLong; demSeas demLong];

figure(figNum);

b = bar(categories,vac,'stacked');
ylabel('\% of Vacancies')
yticks([0 0.1 0.2 0.3 0.4 0.5 0.6])
yticklabels({'0','10','20','30','40','50','60'});

text(0.85,0.25,'Long-term','FontSize',15)
text(0.925,0.22,'36.2\%','FontSize',15)
text(0.85,0.05,'Temporary','FontSize',15)
text(0.95,0.02,'7.7\%','FontSize',15)

text(1.85,0.3,'Long-term','FontSize',15)
text(1.925,0.27,'47.4\%','FontSize',15)
text(1.85,0.05,'Temporary','FontSize',15)
text(1.95,0.02,'8.7\%','FontSize',15)


b(1).FaceColor = [     0    0.4470    0.7410];
b(1).FaceAlpha = 0.7;
b(2).FaceColor = [0.8500    0.3250    0.0980];
b(2).FaceAlpha = 0.7;
set(gca,ls.fontSpec{:})


print(gcf, '-dpdf', [ls.graphPath '/IAB_Vacancy_Share_bar.pdf']);